UL_Mine_Homemade_Lure = {
    Client = {},

    Server = {},

    Properties = {
        shooterId = 0,
    },

    Physics = {
        bRigidBodyActive = 1,
        bActivateOnDamage = 0,
        bResting = 0, -- If rigid body is originally in resting state.
        bCanBreakOthers = 0,

        bPhysicalize = 1, -- True if object should be physicalized at all.
        bRigidBody = 1, -- True if rigid body, False if static.
        bPushableByPlayers = 1,

        Density = 1,
        Mass = 10,

        Simulation =
        {
            max_time_step = 0.02,
            sleep_speed = 0.04,
            damping = 0,
            bFixedDamping = 0,
            bUseSimpleSolver = 0,
        },
        Buoyancy=
        {
            water_density = 1000,
            water_damping = 0,
            water_resistance = 1000,
        },
    },

    Physics_Ground = {
        bRigidBodyActive = 0,
        bActivateOnDamage = 0,
        bResting = 1, -- If rigid body is originally in resting state.
        bCanBreakOthers = 0,

        bPhysicalize = 0, -- True if object should be physicalized at all.
        bRigidBody = 0, -- True if rigid body, False if static.
        bPushableByPlayers = 0,

        Density = -1,
        Mass = -1,
    },

    Definitions = {
       placingModel = "objects/class3_2/objects/nuke/nuke.cgf",
        placedModel = "objects/class3_2/objects/nuke/nuke.cgf",
        DetectRadius = 2,
        Placement = {
            DecalMaterial       = "materials/decals/target.mtl",
        },
        Explosion = {
            Damage              = 10000000000000,
            Decal               = "materials/decals/explosions/explosion_metal.mtl",
            DecalScale          = 0.25,
            Direction           = {x = 0.0, y = 0.0, z = -1}, 
            Effect              = 'Class3Explosions.DLC.Nuke_Flash',
            EffectScale         = 1.0,
            HitType             = "frag",
            HoleSize            = 10,
            MaxPhysRadius       = 100000000000,
            MinPhysRadius       = 100000000000,
            MinRadius           = 100000000000,
            Pressure            = 100000000000,
            Radius              = 100000000000,
            soundRadius         = 9900000000099,
            disturbanceVal      = 25,
        },
        Vulnerability = {
            fDamageThreshold    = 0,
            bExplosion          = 0,
            bCollision          = 0,
            bMelee              = 0,
            bBullet             = 1,
            bOther              = 0,
        },

        WhistlesLeft = 3,
    },

    ParticleProps = {
        bActive=1,  -- Activate on startup
        bPrime=1,   -- Starts in equilibrium state, as if activated in past
        Scale=1.0, -- Scale entire effect size.
        SpeedScale=1,   -- Scale particle emission speed
        CountScale=1,   -- Scale particle counts.
        bCountPerUnit=0,    -- Multiply count by attachment extent
        Strength=-1,        -- Custom param control
        esAttachType="",    -- BoundingBox, Physics, Render
        esAttachForm="",    -- Vertices, Edges, Surface, Volume
        PulsePeriod=0,          -- Restart continually at this period.
    },


    Editor = {
        Icon = "mine.bmp",
        ShowBounds = 1,
    },

    States = {"Placing", "Armed", "Destroyed"},

    AudioCache = 'toy_whistlingmine',
    AudioCacheLifetime = 40.0,
}

local DETONATION_TIMER      = 2
local DETONATION_DELAY      = 30000

local ARMING_TIMER      = 3
local ARMING_DELAY      = 5000

local SOUND_TIMER = 4
local SOUND_DELAY_MIN = 5500
local SOUND_DELAY_MAX = 5800

local ZOMBIE_TIMER = 5

function UL_Mine_Homemade_Lure:OnReset()
    local defs = UL_Mine_Homemade_Lure.Definitions
    if not EmptyString(defs.placingModel) then
        self:LoadObject(0, defs.placingModel)
    end

    self:SetCurrentSlot(0)
    self.WhistlesLeft = defs.WhistlesLeft
    self.health = 1
    self.ents = {}

    local pos = {x = 0, y = 0, z = 0}
    CopyVector(pos, self:GetPos())
    pos.z = System.GetTerrainElevation(self:GetPos()) + 0.5
    self:SetPos(pos)

    self:SetViewDistRatio(255);

    EntityCommon.PhysicalizeRigid(self, 0, self.Physics_Ground, 0)
    self:AwakePhysics(0)
    self:SetWorldAngles(g_Vectors.up)

--    EntityCommon.PhysicalizeRigid(self, 0, self.Physics, 1 );
--    self:AwakePhysics(1);

    self:GotoState("Placing")
end

function UL_Mine_Homemade_Lure:OnPropertyChange()
    self:OnReset()
end

function UL_Mine_Homemade_Lure:OnInitCommon()
    Sound.CacheAudioFile(self.AudioCache)
    self.health = 1
    self.ents = {}
    self.tmp = {x = 0, y = 0, z = 0}
    self.tmp_2 = {x = 0, y = 0, z = 0}
    self.tmp_3 = {x = 0, y = 0, z = 0}
    self:OnReset()
end

function UL_Mine_Homemade_Lure.Server:OnInit()
    UL_Mine_Homemade_Lure.OnInitCommon(self)
end

function UL_Mine_Homemade_Lure.Client:OnInit()
    UL_Mine_Homemade_Lure.OnInitCommon(self)
end

function UL_Mine_Homemade_Lure:IsDead()
    if self.health <= 0 then
        return true
    else
        return false
    end
end

function UL_Mine_Homemade_Lure:SetCurrentSlot(slot)
    if slot == 0 then
        self:DrawSlot(0, 1)
        self:DrawSlot(1, 0)
    else
        self:DrawSlot(0, 0)
        self:DrawSlot(1, 1)
    end
    self.currentSlot = slot
end
-----------------------------------------------------
function UL_Mine_Homemade_Lure.Delete(entity)
    entity:DeleteThis()
end
-----------------------------------------------------
function UL_Mine_Homemade_Lure:Explode()
    self:PlaySoundEvent("sounds/dlc2/explosions_dlc2:exp_specific:nuke", g_Vectors.v000, g_Vectors.v010, SOUND_DEFAULT_3D, SOUND_SEMANTIC_PLAYER_FOLEY);

    self:Hide(1)
    local props = self.Properties
    local defs = UL_Mine_Homemade_Lure.Definitions
    local explosion = defs.Explosion
    local radius = explosion.Radius

    local hitTypeId = g_gameRules.game:GetHitTypeId(explosion.HitType)

    g_gameRules.game:ServerExplosion(
        props.shooterId,            -- shooter id
        self.id,                    -- weapon id
        explosion.Damage,           -- damage
        self:GetWorldPos(),         -- pos
        explosion.Direction,        -- dir
        radius,                     -- radius
        0,                          -- angle
        explosion.Pressure,         -- pressure
        explosion.HoleSize,         -- hole size
        explosion.Effect,           -- effect
        explosion.EffectScale,      -- effect scale
        hitTypeId,                  -- hit type id
        explosion.MinRadius,        -- min radius
        explosion.MinPhysRadius,    -- min phys radius
        explosion.maxPhysRadius,    -- phys radius
        explosion.soundRadius,      -- sound radius
        explosion.disturbanceVal    -- disturbance value
    )

    if explosion.Decal ~= "" then
        local decalDir = g_Vectors.up
        Particle.CreateMatDecal(
            self:GetWorldPos(),
            decalDir,
            radius * explosion.DecalScale,
            300,
            explosion.Decal,
            math.random() * 360,
            decalDir
        )
    end

    local params = {
        class = "CameraShake";
        properties = {
            vector_Position = self:GetPos(),
            fRadius = 40.0,
            fStrength = 2.0,
            fDuration = 1.0,
            fFrequency = 50.0,
        }
    }
    local ent = System.SpawnEntity(params, self.id);
    ent:Event_Shake();

    local cacheParams = {
        class = "AudioCache",
        properties = {
            cacheName = self.AudioCache,
            lifetime = self.AudioCacheLifetime,
        }
    }
    System.SpawnEntity(cacheParams, self.id)
    Sound.RemoveCachedAudioFile(self.AudioCache)

    Script.SetTimerForFunction(3000, "UL_Mine_Homemade_Lure.Delete", self);
end
----------------------------------------------------------------------------------
------------------------------------States----------------------------------------
----------------------------------------------------------------------------------
UL_Mine_Homemade_Lure.Server.Placing = {
    OnBeginState = function(self)
        BroadcastEvent(self, "Placing")
        self:PlaySoundEvent("sounds/explosions:exp_toys:whistling_mine_place", g_Vectors.v000, g_Vectors.v010, SOUND_DEFAULT_3D, SOUND_SEMANTIC_PLAYER_FOLEY);
        self:SetTimer(ARMING_TIMER, ARMING_DELAY)
    end,

    OnTimer = function(self,timerId,msec)
        if timerId == ARMING_TIMER then
            self:GotoState("Armed")
        end
    end,
}

UL_Mine_Homemade_Lure.Server.Armed = {
    OnBeginState = function(self)
        local defs = UL_Mine_Homemade_Lure.Definitions

        if not EmptyString(defs.placedModel) then
            self:LoadObject(0, defs.placedModel)
        end

        local selfPos = self:GetPos();
       

        -- particle fx
        self:LoadParticleEffect(3, 'Class3Explosions.Grenade.whistling_flare', self.ParticleProps)
        local translatePos = {x = 0, y = -0.04, z = 0.4}
        local rotatePos = {x = 1, y = 0, z = 0}
        self:SetSlotPos(3, translatePos)
        self:SetSlotAngles(3, rotatePos)

        self:LoadParticleEffect(2, 'Class3Explosions.Grenade.whistling_flare', self.ParticleProps)
        translatePos = {x = -0.04, y = 0.03, z = 0.36}
        rotatePos = {x = 1, y = 0, z = 0}
        self:SetSlotPos(2, translatePos)
        self:SetSlotAngles(2, rotatePos)

        Zombie.CreateEcho(selfPos, 60, 10.0, 1, 50.0)
        Zombie.CreateDrawAggro(selfPos, 40, 32.0);

        self:SetTimer(DETONATION_TIMER, DETONATION_DELAY)
        self:SetTimer(ZOMBIE_TIMER, DETONATION_DELAY - 100)
        self:SetTimer(SOUND_TIMER, random(SOUND_DELAY_MIN, SOUND_DELAY_MAX))

        BroadcastEvent(self, "Armed")
    end,

    OnTimer = function(self,timerId,msec)
        if timerId == SOUND_TIMER then
            local selfPos = self:GetPos();
           
            Zombie.CreateEcho(selfPos, 60, 10.0, 1, 50.0)

            self.WhistlesLeft = self.WhistlesLeft - 1
--            Log("FOGE: WhistlesLeft: "..self.WhistlesLeft)
            if(self.WhistlesLeft > 0) then
                self:SetTimer(SOUND_TIMER, random(SOUND_DELAY_MIN, SOUND_DELAY_MAX))
            end
        end

        if timerId == ZOMBIE_TIMER then
            Zombie.ActivateInCircle(self:GetWorldPos(), 1 * UL_Mine_Homemade_Lure.Definitions.Explosion.Radius, 12)
        end

        if timerId == DETONATION_TIMER then
            self:GotoState("Destroyed")
        end
    end,
}

UL_Mine_Homemade_Lure.Server.Destroyed = {
    OnBeginState = function(self)
        self:Explode()
        BroadcastEvent(self, "Detonated")
    end,
}